<?php $__env->startSection('page-title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Users</h5>
                        <h2><?php echo e($totalUsers); ?></h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-users"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Transactions</h5>
                        <h2><?php echo e($totalTransactions); ?></h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-list"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Revenue</h5>
                        <h2><?php echo e(number_format($totalRevenue, 2)); ?></h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Expenses</h5>
                        <h2><?php echo e(number_format($totalExpenses, 2)); ?></h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-minus-circle"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Recent Users</div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $recentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item"><?php echo e($u->name); ?> &middot; <?php echo e($u->email); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Top Users (by income)</div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $topUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item"><?php echo e($u->name); ?> — <?php echo e(number_format($u->total_income, 2)); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/dashboard/admin.blade.php ENDPATH**/ ?>