<?php $__env->startSection('page-title', 'Products'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Products</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Product
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>SKU</th>
                            <th>Unit</th>
                            <th>Current Stock</th>
                            <th>Min Stock</th>
                            <th>total purchase price</th>
                            <th>Purchase Price</th>
                            <th>Sales Price</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($product->name); ?></td>
                                <td><?php echo e($product->sku ?? '-'); ?></td>
                                <td><?php echo e($product->unit ?? '-'); ?></td>
                                <td>
                                    <?php if($product->current_stock <= $product->minimum_stock): ?>
                                        <span class="badge bg-danger"><?php echo e($product->current_stock); ?></span>
                                    <?php else: ?>
                                        <?php echo e($product->current_stock); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($product->minimum_stock); ?></td>
                                <td><?php echo e(number_format($product->total_purchase_price, 2)); ?></td>
                                <td><?php echo e(number_format($product->purchase_price, 2)); ?></td>
                                <td><?php echo e(number_format($product->sales_price, 2)); ?></td>
                                <td>
                                    <a href="<?php echo e(route('products.edit', $product->id)); ?>" class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('products.destroy', $product->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">No products found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/products/index.blade.php ENDPATH**/ ?>