<?php $__env->startSection('page-title', 'Cash Book Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Cash Book</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('reports.cash-book')); ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo e($fromDate); ?>">
                </div>
                <div class="col-md-4">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo e($toDate); ?>">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5>Opening Balance</h5>
                    <h4><?php echo e(number_format($openingBalance, 2)); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Total Receipts</h5>
                    <h4><?php echo e(number_format($totalReceipts, 2)); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Payments</h5>
                    <h4><?php echo e(number_format($totalPayments, 2)); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5>Closing Balance</h5>
                    <h4><?php echo e(number_format($closingBalance, 2)); ?></h4>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Details</th>
                            <th>Receipts</th>
                            <th>Payments</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($transaction->date->format('M d, Y')); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($transaction->type == 'income' ? 'success' : 'danger'); ?>">
                                        <?php echo e(ucfirst($transaction->type)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($transaction->details ?? '-'); ?></td>
                                <td><?php echo e($transaction->type == 'income' ? number_format($transaction->amount, 2) : '-'); ?></td>
                                <td><?php echo e($transaction->type == 'expense' ? number_format($transaction->amount, 2) : '-'); ?></td>
                                <td><?php echo e(number_format($transaction->balance_after, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No transactions found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/reports/cash-book.blade.php ENDPATH**/ ?>