
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Accounting System')); ?></title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Custom CSS -->
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #2c3e50 0%, #1a252f 100%);
        }
        .sidebar .nav-link {
            color: #ecf0f1;
            padding: 0.8rem 1rem;
            margin: 0.2rem 0;
            border-radius: 0.25rem;
        }
        .sidebar .nav-link:hover {
            background-color: #34495e;
            color: white;
        }
        .sidebar .nav-link.active {
            background-color: #3498db;
            color: white;
        }
        .sidebar .nav-link i {
            margin-right: 0.5rem;
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        .stat-icon {
            font-size: 2rem;
            color: #3498db;
        }
        .filter-section {
            background: white;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-2 d-md-block sidebar p-0">
                <div class="p-3 text-white">
                    <h4 class="text-center mb-4">Accounting System</h4>
                    <hr class="bg-white">
                </div>

                <div class="nav flex-column px-2">
                    <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>"
                       href="<?php echo e(route('dashboard')); ?>">
                        <i class="fas fa-tachometer-alt"></i> Dashboard
                    </a>

                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->isAdmin()): ?>
                            <a class="nav-link <?php echo e(request()->routeIs('admin.users*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.users')); ?>">
                                <i class="fas fa-users"></i> Users
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div class="nav-item">
                        <span class="nav-link text-white-50"><i class="fas fa-wallet"></i> Accounts</span>
                        <div class="ms-3">
                            <a class="nav-link <?php echo e(request()->routeIs('bank-accounts*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('bank-accounts.index')); ?>">
                                <i class="fas fa-university"></i> Bank Accounts
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('digital-payments*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('digital-payments.index')); ?>">
                                <i class="fas fa-mobile-alt"></i> Digital Payments
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('cash*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('cash.index')); ?>">
                                <i class="fas fa-money-bill"></i> Cash
                            </a>
                        </div>
                    </div>

                    <div class="nav-item">
                        <span class="nav-link text-white-50"><i class="fas fa-exchange-alt"></i> Transactions</span>
                        <div class="ms-3">
                            <a class="nav-link <?php echo e(request()->routeIs('transactions*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('transactions.index')); ?>">
                                <i class="fas fa-list"></i> All Transactions
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('expense-types*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('expense-types.index')); ?>">
                                <i class="fas fa-minus-circle"></i> Expenses type
                            </a>

                            <a class="nav-link <?php echo e(request()->routeIs('particulars.*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('particulars.index')); ?>">
                                <i class="fas fa-list-alt"></i> Particulars
                            </a>

                            <a class="nav-link <?php echo e(request()->routeIs('expenses*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('expenses.index')); ?>">
                                <i class="fas fa-minus-circle"></i> Expenses
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('invoices*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('invoices.index')); ?>">
                                <i class="fas fa-file-invoice"></i> Invoices
                            </a>
                             <a class="nav-link <?php echo e(request()->routeIs('segments*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('segments.index')); ?>">
                                <i class="fas fa-file-invoice"></i> Segments
                            </a>

                        </div>
                    </div>

                    <div class="nav-item">
                        <span class="nav-link text-white-50"><i class="fas fa-box"></i> Products</span>
                        <div class="ms-3">
                            <a class="nav-link <?php echo e(request()->routeIs('products*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('products.index')); ?>">
                                <i class="fas fa-cube"></i> Products
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('stock*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('stock.index')); ?>">
                                <i class="fas fa-warehouse"></i> Stock
                            </a>

                        </div>
                    </div>

                    <div class="nav-item">
                        <span class="nav-link text-white-50"><i class="fas fa-chart-bar"></i> Reports</span>
                        <div class="ms-3">
                            <a class="nav-link <?php echo e(request()->routeIs('reports.profit-loss') ? 'active' : ''); ?>"
                               href="<?php echo e(route('reports.profit-loss')); ?>">
                                <i class="fas fa-chart-line"></i> P&L
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('reports.balance-sheet') ? 'active' : ''); ?>"
                               href="<?php echo e(route('reports.balance-sheet')); ?>">
                                <i class="fas fa-balance-scale"></i> Balance Sheet
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('reports.cash-book') ? 'active' : ''); ?>"
                               href="<?php echo e(route('reports.cash-book')); ?>">
                                <i class="fas fa-book"></i> Cash Book
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('reports.bank-book') ? 'active' : ''); ?>"
                               href="<?php echo e(route('reports.bank-book')); ?>">
                                <i class="fas fa-book-open"></i> Bank Book
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('reports.sales') ? 'active' : ''); ?>"
                               href="<?php echo e(route('reports.sales')); ?>">
                                <i class="fas fa-chart-pie"></i> Sales Report
                            </a>
                            <a class="nav-link <?php echo e(request()->routeIs('sales-dashboard*') ? 'active' : ''); ?>"
                               href="<?php echo e(route('sales-dashboard.index')); ?>">
                                <i class="fas fa-chart-pie"></i> Sales Dashboard
                            </a>
                        </div>
                    </div>

                    <hr class="bg-white">

                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="nav-link text-danger bg-transparent border-0 w-100 text-start">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </button>
                    </form>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-10 main-content p-4">
                <!-- Top Navigation -->
                <nav class="navbar navbar-expand navbar-light bg-white rounded mb-4 shadow-sm">
                    <div class="container-fluid">
                        <div class="navbar-brand">
                            <?php echo $__env->yieldContent('page-title', 'Dashboard'); ?>
                        </div>
                        <div class="navbar-nav ms-auto">
                            <div class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="userDropdown"
                                   role="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-user-circle"></i>
                                    <?php if(auth()->guard()->check()): ?>
                                        <?php echo e(auth()->user()->name); ?>

                                    <?php else: ?>
                                        Guest
                                    <?php endif; ?>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <?php if(auth()->guard()->check()): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
                                            <i class="fas fa-user"></i> Profile
                                        </a>
                                        <a class="dropdown-item" href="<?php echo e(route('settings')); ?>">
                                            <i class="fas fa-cog"></i> Settings
                                        </a>
                                        <div class="dropdown-divider"></div>
                                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="dropdown-item text-danger">
                                                <i class="fas fa-sign-out-alt"></i> Logout
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <a class="dropdown-item" href="<?php echo e(route('login')); ?>">Login</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>

                <!-- Alert Messages -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Page Content -->
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- jQuery (if needed) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Custom JS -->
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/layouts/app.blade.php ENDPATH**/ ?>