<?php $__env->startSection('page-title', 'Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Transactions</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Transaction
            </a>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Total Income</h5>
                    <h3><?php echo e(number_format($totalIncome, 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Expenses</h5>
                    <h3><?php echo e(number_format($totalExpense, 2)); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('transactions.index')); ?>" class="row g-3">
                <div class="col-md-2">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo e(request('from_date')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo e(request('to_date')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="type" class="form-label">Type</label>
                    <select class="form-select" id="type" name="type">
                        <option value="">All</option>
                        <option value="income" <?php echo e(request('type') == 'income' ? 'selected' : ''); ?>>Income</option>
                        <option value="expense" <?php echo e(request('type') == 'expense' ? 'selected' : ''); ?>>Expense</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="payment_method" class="form-label">Payment Method</label>
                    <select class="form-select" id="payment_method" name="payment_method">
                        <option value="">All</option>
                        <option value="cash" <?php echo e(request('payment_method') == 'cash' ? 'selected' : ''); ?>>Cash</option>
                        <option value="bank" <?php echo e(request('payment_method') == 'bank' ? 'selected' : ''); ?>>Bank</option>
                        <option value="digital" <?php echo e(request('payment_method') == 'digital' ? 'selected' : ''); ?>>Digital</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filter</button>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary w-100">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Payment Method</th>
                            <th>Details</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($transaction->date->format('M d, Y')); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($transaction->type == 'income' ? 'success' : 'danger'); ?>">
                                        <?php echo e(ucfirst($transaction->type)); ?>

                                    </span>
                                </td>
                                <td><?php echo e(number_format($transaction->amount, 2)); ?></td>
                                <td><?php echo e(ucfirst($transaction->payment_method)); ?></td>
                                <td><?php echo e($transaction->details ?? '-'); ?></td>
                                <td>
                                    <a href="<?php echo e(route('transactions.show', $transaction->id)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No transactions found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($transactions->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/transactions/index.blade.php ENDPATH**/ ?>