<?php $__env->startSection('page-title', 'User Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Today's Income</h6>
                    <h3 class="mb-0 text-success">৳<?php echo e(number_format($todayIncome, 2)); ?></h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-arrow-up text-success"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Today's Expense</h6>
                    <h3 class="mb-0 text-danger">৳<?php echo e(number_format($todayExpense, 2)); ?></h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-arrow-down text-danger"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Monthly Income</h6>
                    <h3 class="mb-0 text-success">৳<?php echo e(number_format($monthlyIncome, 2)); ?></h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-calendar-alt text-info"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Monthly Expense</h6>
                    <h3 class="mb-0 text-danger">৳<?php echo e(number_format($monthlyExpense, 2)); ?></h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-calendar-alt text-info"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Account Balances</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="fw-bold">Cash Balance:</label>
                    <span class="text-success ms-2">৳<?php echo e(number_format($cashBalance, 2)); ?></span>
                </div>

                <?php if($bankAccounts->count() > 0): ?>
                    <h6 class="mt-3">Bank Accounts</h6>
                    <div class="list-group">
                        <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?php echo e($account->account_name); ?></strong><br>
                                    <small class="text-muted"><?php echo e($account->bank_name); ?></small>
                                </div>
                                <span class="badge bg-success rounded-pill">৳<?php echo e(number_format($account->balance, 2)); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <?php if($digitalAccounts->count() > 0): ?>
                    <h6 class="mt-3">Digital Payments</h6>
                    <div class="list-group">
                        <?php $__currentLoopData = $digitalAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?php echo e($account->provider); ?></strong><br>
                                    <small class="text-muted"><?php echo e($account->account_number); ?></small>
                                </div>
                                <span class="badge bg-info rounded-pill">৳<?php echo e(number_format($account->balance, 2)); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row g-2">
                    <div class="col-6">
                        <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-success w-100 mb-2">
                            <i class="fas fa-plus-circle"></i> Add Income
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('expenses.create')); ?>" class="btn btn-danger w-100 mb-2">
                            <i class="fas fa-minus-circle"></i> Add Expense
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('bank-accounts.create')); ?>" class="btn btn-primary w-100 mb-2">
                            <i class="fas fa-university"></i> Add Bank Account
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('digital-payments.create')); ?>" class="btn btn-info w-100 mb-2">
                            <i class="fas fa-mobile-alt"></i> Add Digital Account
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-warning w-100 mb-2">
                            <i class="fas fa-file-invoice"></i> New Invoice
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('products.create')); ?>" class="btn btn-secondary w-100 mb-2">
                            <i class="fas fa-cube"></i> Add Product
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Income vs Expense (Last 30 Days)</h5>
            </div>
            <div class="card-body">
                <canvas id="incomeExpenseChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-7">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Recent Transactions</h5>
                <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Voucher No</th>
                                <th>Details</th>
                                <th>Type</th>
                                <th>Method</th>
                                <th class="text-end">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($transaction->date->format('d/m/Y')); ?></td>
                                    <td><?php echo e($transaction->voucher_no); ?></td>
                                    <td><?php echo e(Str::limit($transaction->details, 30)); ?></td>
                                    <td>
                                        <?php if($transaction->type == 'income'): ?>
                                            <span class="badge bg-success">Income</span>
                                        <?php elseif($transaction->type == 'expense'): ?>
                                            <span class="badge bg-danger">Expense</span>
                                        <?php else: ?>
                                            <span class="badge bg-info">Transfer</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($transaction->payment_method == 'cash'): ?>
                                            Cash
                                        <?php elseif($transaction->payment_method == 'bank'): ?>
                                            <?php echo e($transaction->bankAccount?->bank_name ?? 'Bank'); ?>

                                        <?php else: ?>
                                            <?php echo e($transaction->digitalPayment?->provider ?? 'Digital'); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end <?php echo e($transaction->type == 'income' ? 'text-success' : 'text-danger'); ?>">
                                        <?php echo e($transaction->type == 'income' ? '+' : '-'); ?> ৳<?php echo e(number_format($transaction->amount, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">No transactions found</p>
                                        <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-primary btn-sm">
                                            Add your first transaction
                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Low Stock Alert</h5>
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-sm btn-primary">Manage Products</a>
            </div>
            <div class="card-body">
                <?php if($lowStockProducts->count() > 0): ?>
                    <div class="list-group">
                        <?php $__currentLoopData = $lowStockProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?php echo e($product->name); ?></strong><br>
                                        <small class="text-muted">Code: <?php echo e($product->product_code); ?></small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-warning text-dark">Stock: <?php echo e($product->current_stock); ?></span><br>
                                        <small class="text-muted">Min: <?php echo e($product->minimum_stock); ?></small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                        <p class="text-muted">All products have sufficient stock</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('incomeExpenseChart').getContext('2d');

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($chartData['labels']); ?>,
            datasets: [{
                label: 'Income',
                data: <?php echo json_encode($chartData['income']); ?>,
                borderColor: '#28a745',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                tension: 0.1,
                fill: true
            }, {
                label: 'Expense',
                data: <?php echo json_encode($chartData['expense']); ?>,
                borderColor: '#dc3545',
                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '৳' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/dashboard/user.blade.php ENDPATH**/ ?>