<?php $__env->startSection('page-title', 'Sales Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Sales Dashboard</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('sales-dashboard.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Record
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-sm">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Invoice</th>
                            <th>Product</th>
                            <th>QTY</th>
                            <th>Sales</th>
                            <th>Particulars</th>
                            <th>Payment</th>
                            <th>Due</th>
                            <th>COGS</th>
                            <th>Gross Profit</th>
                            <th>%</th>
                            <th>Cash Received By</th>
                            <th>Segment</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $totalSales = $salesDashboards->sum('sales');
                            $totalPayment = $salesDashboards->sum('payment');
                            $totalDue = $salesDashboards->sum('due');
                            $totalCogs = $salesDashboards->sum('cogs');
                            $totalGross = $salesDashboards->sum('gross_profit');
                            $totalAmount = $salesDashboards->sum('amount');
                        ?>

                        <?php $__empty_1 = true; $__currentLoopData = $salesDashboards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($record->date ? $record->date->format('Y-m-d') : '-'); ?></td>
                                <td><?php echo e($record->invoice ?? '-'); ?></td>
                                <td><?php echo e($record->product ?? '-'); ?></td>
                                <td><?php echo e($record->qty ?? '-'); ?></td>
                                <td><?php echo e($record->sales ? number_format($record->sales, 2) : '-'); ?></td>
                                <td><?php echo e($record->particulars ?? '-'); ?></td>
                                <td><?php echo e($record->payment ? number_format($record->payment, 2) : '-'); ?></td>
                                <td><?php echo e($record->due ? number_format($record->due, 2) : '-'); ?></td>
                                <td><?php echo e($record->cogs ? number_format($record->cogs, 2) : '-'); ?></td>
                                <td><?php echo e($record->gross_profit ? number_format($record->gross_profit, 2) : '-'); ?></td>
                                <td><?php echo e($record->percentage ? number_format($record->percentage, 2) : '-'); ?></td>
                                <td><?php echo e($record->cash_received_by ?? '-'); ?></td>
                                <td><?php echo e($record->segment ?? '-'); ?></td>
                                <td><?php echo e($record->amount ? number_format($record->amount, 2) : '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="14" class="text-center">No records found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                    <tfoot>
                        <tr class="fw-bold">
                            <td colspan="4">Total</td>
                            <td><?php echo e(number_format($totalSales, 2)); ?></td>
                            <td></td>
                            <td><?php echo e(number_format($totalPayment, 2)); ?></td>
                            <td><?php echo e(number_format($totalDue, 2)); ?></td>
                            <td><?php echo e(number_format($totalCogs, 2)); ?></td>
                            <td><?php echo e(number_format($totalGross, 2)); ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td><?php echo e(number_format($totalAmount, 2)); ?></td>
                        </tr>
                    </tfoot>
                </table>

                
                <?php
                    $segments = $salesDashboards->groupBy(function($r){ return $r->segment ?? 'Unspecified'; });
                    $dayGroups = $salesDashboards->groupBy(function($r){ return $r->date ? $r->date->format('Y-m-d') : 'No Date'; });
                ?>

                <div class="row mt-4">
                    <div class="col-md-6">
                        <h5>Segment Wise Sales</h5>
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>Segment</th>
                                    <th>QTY</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $segments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($segment); ?></td>
                                        <td><?php echo e($rows->sum('qty')); ?></td>
                                        <td><?php echo e(number_format($rows->sum('amount'), 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h5>Day Wise Sales</h5>
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Qty</th>
                                    <th>Amount</th>
                                    <th>COGS</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $dayGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($day); ?></td>
                                        <td><?php echo e($rows->sum('qty')); ?></td>
                                        <td><?php echo e(number_format($rows->sum('sales'), 2)); ?></td>
                                        <td><?php echo e(number_format($rows->sum('cogs'), 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/sales-dashboard/index.blade.php ENDPATH**/ ?>