<?php $__env->startSection('page-title', 'Sales Report - Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
	<div class="row">
		 <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('reports.sales')); ?>" class="row g-3">
                <div class="col-md-3">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo e($fromDate); ?>">
                </div>
                <div class="col-md-3">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo e($toDate); ?>">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="button" class="btn btn-secondary w-100" onclick="window.print()">Print Report</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Main Content Area - Two Column Layout -->
    <div class="row g-4">
        <!-- LEFT SIDE: Sales Table -->
        <div class="col-lg-8">
            <div class="card h-100">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-bold text-dark">Sales Details</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered mb-0" style="font-size: 12px;">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-start" style="width: 50px;">Date</th>
                                    <th class="text-start" style="width: 80px;">Invoice</th>
                                    <th class="text-start">Product</th>
                                    <th class="text-center" style="width: 50px;">QTY</th>
                                    <th class="text-end">Sales</th>
                                    <th class="text-start">Particulars</th>
                                    <th class="text-center">Payment</th>
                                    <th class="text-end">Due</th>
                                    <th class="text-end">COGS</th>
                                    <th class="text-end">Gross Profit</th>
                                    <th class="text-end" style="width: 50px;">%</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $salesLines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($line['date']->format('j')); ?></td>
                                        <td class="fw-medium"><?php echo e($line['invoice_no']); ?></td>
                                        <td><?php echo e(substr($line['product_name'], 0, 15)); ?></td>
                                        <td class="text-center"><?php echo e($line['qty']); ?></td>
                                        <td class="text-end"><?php echo e(number_format($line['total_sales'], 0)); ?></td>
                                        <td>Payment</td>
                                        <td class="text-center">
                                            <?php if($line['payment_method'] === 'Paid'): ?>
                                                <span class="badge bg-success"><?php echo e(number_format($line['paid'])); ?></span>
                                            <?php elseif($line['payment_method'] === 'Partial'): ?>
                                                <span class="badge bg-warning text-dark"><?php echo e(number_format($line['paid'])); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end"><?php echo e(number_format($line['due'], 0)); ?></td>
                                        <td class="text-end"><?php echo e(number_format($line['cogs'], 0)); ?></td>
                                        <td class="text-end"><?php echo e(number_format($line['gross_profit'], 0)); ?></td>
                                        <td class="text-end"><?php echo e(number_format($line['percentage'], 0)); ?>%</td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="11" class="text-center text-muted py-4">No sales data found for the selected period.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT SIDE: Dashboard -->
        <div class="col-lg-4">
            <!-- Sales Summary Cards -->
            <div class="card mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-dark">Dashboard</h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center pb-3 mb-3 border-bottom">
                        <span class="text-muted small">Sales</span>
                        <span class="fw-bold text-success fs-5"><?php echo e(number_format($summary['total_sales'], 0)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center pb-3 mb-3 border-bottom">
                        <span class="text-muted small">Cash Received By</span>
                        <span class="fw-bold text-primary fs-5"><?php echo e(number_format($summary['total_paid'], 0)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center pb-3 mb-3 border-bottom">
                        <span class="text-muted small">Previous Due</span>
                        <span class="fw-bold text-secondary fs-5">-</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center pb-3 mb-3 border-bottom">
                        <span class="text-muted small">Others</span>
                        <span class="fw-bold text-secondary fs-5">-</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center pb-3 mb-3 border-bottom">
                        <span class="text-muted small">Total Income</span>
                        <span class="fw-bold text-info fs-5"><?php echo e(number_format($summary['total_paid'], 0)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted small">Due</span>
                        <span class="fw-bold text-danger fs-5"><?php echo e(number_format($summary['total_due'], 0)); ?></span>
                    </div>
                </div>
            </div>

            <!-- Payment Method Breakdown -->
            <div class="card mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-dark">Cash Received By</h6>
                </div>
                <div class="card-body p-0">
                    <table class="table table-sm mb-0" style="font-size: 12px;">
                        <thead class="table-light">
                            <tr>
                                <th class="text-start">Payment</th>
                                <th class="text-end">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $paymentBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($method); ?></td>
                                    <td class="text-end fw-medium"><?php echo e(number_format($data['total'], 0)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="table-light fw-bold">
                                <td>Total</td>
                                <td class="text-end"><?php echo e(number_format($summary['total_paid'], 0)); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Day Wise Sales -->
            <div class="card mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-dark">Day Wise Sales</h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive" style="max-height: 300px;">
                        <table class="table table-sm table-bordered mb-0" style="font-size: 11px;">
                            <thead class="table-light position-sticky top-0">
                                <tr>
                                    <th class="text-center">Date</th>
                                    <th class="text-center">Qty</th>
                                    <th class="text-end">Amount</th>
                                    <th class="text-end">Costing</th>
                                    <th class="text-end">Cost PP</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $dayWiseSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($day['day']); ?></td>
                                        <td class="text-center"><?php echo e($day['qty']); ?></td>
                                        <td class="text-end"><?php echo e(number_format($day['amount'], 0)); ?></td>
                                        <td class="text-end"><?php echo e(number_format($day['cogs'], 1)); ?></td>
                                        <td class="text-end"><?php echo e(number_format($day['cost_per_item'], 1)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-3">No data</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Segment Wise Sale -->
            <div class="card">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-bold text-dark">Segment Wise Sale</h6>
                </div>
                <div class="card-body p-0">
                    <table class="table table-sm table-bordered mb-0" style="font-size: 11px;">
                        <thead class="table-light">
                            <tr>
                                <th class="text-start">Segment</th>
                                <th class="text-center">QTY</th>
                                <th class="text-end">Amount</th>
                                <th class="text-center">KPI</th>
                                <th class="text-end">Revenue</th>
                                <th class="text-end">Achiv</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $segmentWiseSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($segment['segment_name']); ?></td>
                                    <td class="text-center"><?php echo e($segment['qty']); ?></td>
                                    <td class="text-end"><?php echo e(number_format($segment['amount'], 0)); ?></td>
                                    <td class="text-center"><?php echo e($segment['kpi']); ?></td>
                                    <td class="text-end"><?php echo e(number_format($segment['revenue'], 0)); ?></td>
                                    <td class="text-end"><?php echo e($segment['achievement']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-3">No segment data</td>
                                </tr>
                            <?php endif; ?>
                            <tr class="table-light fw-bold">
                                <td>Total</td>
                                <td class="text-center">-</td>
                                <td class="text-end">-</td>
                                <td class="text-center">-</td>
                                <td class="text-end">-</td>
                                <td class="text-end">-</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/reports/sales.blade.php ENDPATH**/ ?>