<?php $__env->startSection('page-title', 'Profit & Loss Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Profit & Loss Report</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('reports.profit-loss')); ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="year" class="form-label">Year</label>
                    <select class="form-select" id="year" name="year">
                        <?php for($y = now()->year; $y >= now()->year - 5; $y--): ?>
                            <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="month" class="form-label">Month</label>
                    <select class="form-select" id="month" name="month">
                        <?php for($m = 1; $m <= 12; $m++): ?>
                            <option value="<?php echo e($m); ?>" <?php echo e($month == $m ? 'selected' : ''); ?>>
                                <?php echo e(Carbon\Carbon::create()->month($m)->format('F')); ?>

                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Total Income</h5>
                    <h3><?php echo e(number_format($income, 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Expenses</h5>
                    <h3><?php echo e(number_format($expenses, 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-<?php echo e($netProfit >= 0 ? 'success' : 'danger'); ?> text-white">
                <div class="card-body">
                    <h5>Net Profit</h5>
                    <h3><?php echo e(number_format($netProfit, 2)); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Expense Breakdown -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expense Breakdown by Type</h5>
                </div>
                <div class="card-body">
                    <?php if($expenseBreakdown->count() > 0): ?>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expenseBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->expenseType->name ?? 'Unknown'); ?></td>
                                        <td><?php echo e(number_format($item->total, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center">No expenses recorded.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Segment-wise Expenses -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Segment-wise Expenses</h5>
                </div>
                <div class="card-body">
                    <?php if($segmentExpenses->count() > 0): ?>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Segment</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $segmentExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->segment->name ?? 'Unknown'); ?></td>
                                        <td><?php echo e(number_format($item->total, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center">No segment expenses recorded.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/reports/profit-loss.blade.php ENDPATH**/ ?>