<?php $__env->startSection('page-title', 'Segments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
	<div class="row mb-4">
		<div class="col-md-6">
			<h2>Segments</h2>
		</div>
		<div class="col-md-6 text-end">
			<a href="<?php echo e(route('segments.create')); ?>" class="btn btn-primary">
				<i class="fas fa-plus"></i> Add Segment
			</a>
		</div>
	</div>

	<?php if(session('success')): ?>
		<div class="alert alert-success"><?php echo e(session('success')); ?></div>
	<?php endif; ?>
	<?php if(session('error')): ?>
		<div class="alert alert-danger"><?php echo e(session('error')); ?></div>
	<?php endif; ?>

	<div class="row">
		<div class="col-12">
			<?php if($segments->isEmpty()): ?>
				<div class="alert alert-info">No segments found. <a href="<?php echo e(route('segments.create')); ?>">Create one</a>.</div>
			<?php else: ?>
				<div class="table-responsive">
					<table class="table table-striped table-bordered">
						<thead>
							<tr>
								<th>Name</th>
								<th>Description</th>
								<th class="text-end">Actions</th>
							</tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $segments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($segment->name); ?></td>
									<td><?php echo e($segment->description ?? '-'); ?></td>
									<td class="text-end">
										<a href="<?php echo e(route('segments.edit', $segment->id)); ?>" class="btn btn-sm btn-primary">
											<i class="fas fa-edit"></i> Edit
										</a>
										<form action="<?php echo e(route('segments.destroy', $segment->id)); ?>" method="POST" class="d-inline">
											<?php echo csrf_field(); ?>
											<?php echo method_field('DELETE'); ?>
											<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this segment?')">
												<i class="fas fa-trash"></i> Delete
											</button>
										</form>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/segments/index.blade.php ENDPATH**/ ?>