<?php $__env->startSection('page-title', 'Bank Accounts'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Bank Accounts</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('bank-accounts.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Account
            </a>
        </div>
    </div>

    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><?php echo e($account->bank_name); ?></h5>
                        <?php if($account->is_active): ?>
                            <span class="badge bg-success">Active</span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Inactive</span>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <p><strong>Account Name:</strong> <?php echo e($account->account_name); ?></p>
                        <p><strong>Account Number:</strong> <?php echo e($account->account_number ?? 'N/A'); ?></p>
                        <p><strong>Branch:</strong> <?php echo e($account->branch ?? 'N/A'); ?></p>
                        <p><strong>Balance:</strong> <?php echo e(number_format($account->balance, 2)); ?></p>
                        <p><strong>Transactions:</strong> <?php echo e($account->transactions->count()); ?></p>
                    </div>
                    <div class="card-footer">
                        <a href="<?php echo e(route('bank-accounts.edit', $account->id)); ?>" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <form action="<?php echo e(route('bank-accounts.destroy', $account->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="alert alert-info">
                    No bank accounts found. <a href="<?php echo e(route('bank-accounts.create')); ?>">Add your first account</a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/bank-accounts/index.blade.php ENDPATH**/ ?>