<?php $__env->startSection('page-title', 'Add Product'); ?>

<?php $__env->startSection('content'); ?>
<script>
function togglePaymentFields() {
    const method = document.getElementById('payment_method').value;
    const bankSection = document.getElementById('bank_account_section');
    const digitalSection = document.getElementById('digital_payment_section');
    const totalCostSection = document.getElementById('total_cost');

    if (method === 'bank') {
        bankSection.style.display = 'block';
        digitalSection.style.display = 'none';
        document.getElementById('digital_payment_id').value = '';
    } else if (method === 'digital') {
        bankSection.style.display = 'none';
        digitalSection.style.display = 'block';
        document.getElementById('bank_account_id').value = '';
    } else {
        bankSection.style.display = 'none';
        digitalSection.style.display = 'none';
        totalCostSection.style.display = 'none';
    }

    calculateTotal();
}

function calculateTotal() {
    const purchasePrice = parseFloat(document.getElementById('purchase_price').value) || 0;
    const currentStock = parseInt(document.getElementById('current_stock').value) || 0;
    const totalCost = purchasePrice * currentStock;

    const totalCostSection = document.getElementById('total_cost');
    const costAmount = document.getElementById('cost_amount');

    if (totalCost > 0 && document.getElementById('payment_method').value) {
        costAmount.textContent = totalCost.toFixed(2);
        totalCostSection.style.display = 'block';
    } else {
        totalCostSection.style.display = 'none';
    }
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('purchase_price').addEventListener('input', calculateTotal);
    document.getElementById('current_stock').addEventListener('input', calculateTotal);
});
</script>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Add New Product</h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('products.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name *</label>
                                    <input type="text" class="form-control" id="name" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="sku" class="form-label">SKU</label>
                                    <input type="text" class="form-control" id="sku" name="sku">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="2"></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="unit" class="form-label">Unit</label>
                                    <input type="text" class="form-control" id="unit" name="unit" placeholder="e.g., pcs, kg, box">
                                </div>
                            </div>
                            <div class="col-md-6">
                               <div class="mb-3">
                                    <label for="minimum_stock" class="form-label">Minimum Stock</label>
                                    <input type="number" class="form-control" id="minimum_stock" name="minimum_stock" min="0" value="<?php echo e($product->minimum_stock); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="current_stock" class="form-label">Current Stock</label>
                                    <input type="number" class="form-control" id="current_stock" name="current_stock" min="0" value="<?php echo e($product->current_stock); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="purchase_price" class="form-label">Purchase Price</label>
                                    <input type="number" class="form-control" id="purchase_price" name="purchase_price" step="0.01" min="0" value="<?php echo e($product->purchase_price); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="sales_price" class="form-label">Sales Price</label>
                            <input type="number" class="form-control" id="sales_price" name="sales_price" step="0.01" min="0" value="<?php echo e($product->sales_price ?? 0); ?>">
                        </div>
                        <hr>
                        <h5>Payment Method (For Purchase)</h5>

                        <div class="mb-3">
                            <label for="payment_method" class="form-label">Select Payment Method *</label>
                            <select class="form-control" id="payment_method" name="payment_method" required onchange="togglePaymentFields()">
                                <option value="">-- Choose Payment Method --</option>
                                <option value="bank">Bank Account</option>
                                <option value="digital">Digital Payment</option>
                            </select>
                        </div>

                        <div id="bank_account_section" style="display:none;" class="mb-3">
                            <label for="bank_account_id" class="form-label">Select Bank Account</label>
                            <select class="form-control" id="bank_account_id" name="bank_account_id">
                                <option value="">-- Choose Bank Account --</option>
                                <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($account->id); ?>" data-balance="<?php echo e($account->balance); ?>">
                                        <?php echo e($account->account_name); ?> - <?php echo e($account->bank_name); ?> (Balance: <?php echo e($account->balance); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div id="digital_payment_section" style="display:none;" class="mb-3">
                            <label for="digital_payment_id" class="form-label">Select Digital Payment</label>
                            <select class="form-control" id="digital_payment_id" name="digital_payment_id">
                                <option value="">-- Choose Digital Payment --</option>
                                <?php $__currentLoopData = $digitalPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($payment->id); ?>" data-balance="<?php echo e($payment->balance); ?>">
                                        <?php echo e($payment->provider); ?> - <?php echo e($payment->account_number); ?> (Balance: <?php echo e($payment->balance); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="alert alert-info" id="total_cost" style="display:none;">
                            <strong>Total Purchase Cost:</strong> <span id="cost_amount">0.00</span>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Create Product</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/products/create.blade.php ENDPATH**/ ?>