<?php $__env->startSection('page-title', 'Add Transaction'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Add New Transaction</h4>
                </div>
                <div class="card-body">

                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('transactions.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date" class="form-label">Date *</label>
                                    <input type="date" class="form-control" id="date" name="date" value="<?php echo e(old('date', now()->toDateString())); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">Type *</label>
                                        <select class="form-select" id="type" name="type" required>
                                            <option value="">Select Type</option>
                                            <option value="income" <?php echo e(old('type')=='income' ? 'selected' : ''); ?>>Income</option>
                                            <option value="expense" <?php echo e(old('type')=='expense' ? 'selected' : ''); ?>>Expense</option>
                                        </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="payment_method" class="form-label">Payment Method *</label>
                                        <select class="form-select" id="payment_method" name="payment_method" required>
                                            <option value="">Select Method</option>
                                            <option value="cash" <?php echo e(old('payment_method')=='cash' ? 'selected' : ''); ?>>Cash</option>
                                            <option value="bank" <?php echo e(old('payment_method')=='bank' ? 'selected' : ''); ?>>Bank</option>
                                            <option value="digital" <?php echo e(old('payment_method')=='digital' ? 'selected' : ''); ?>>Digital</option>
                                        </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="amount" class="form-label">Amount *</label>
                                    <input type="number" class="form-control" id="amount" name="amount" step="0.01" min="0.01" value="<?php echo e(old('amount')); ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3" id="bank_account_field" style="display: none;">
                            <label for="bank_account_id" class="form-label">Bank Account</label>
                            <select class="form-select" id="bank_account_id" name="bank_account_id">
                                <option value="">Select Account</option>
                                <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($account->id); ?>" <?php echo e(old('bank_account_id') == $account->id ? 'selected' : ''); ?>><?php echo e($account->bank_name); ?> - <?php echo e($account->account_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3" id="digital_payment_field" style="display: none;">
                            <label for="digital_payment_id" class="form-label">Digital Payment</label>
                            <select class="form-select" id="digital_payment_id" name="digital_payment_id">
                                <option value="">Select Account</option>
                                <?php $__currentLoopData = $digitalPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($payment->id); ?>" <?php echo e(old('digital_payment_id') == $payment->id ? 'selected' : ''); ?>><?php echo e($payment->provider); ?> - <?php echo e($payment->account_number); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3" id="expense_type_field" style="display: none;">
                            <label for="expense_type_id" class="form-label">Expense Type</label>
                            <select class="form-select" id="expense_type_id" name="expense_type_id">
                                <option value="">Select Type</option>
                                <?php $__currentLoopData = $expenseTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->id); ?>" <?php echo e(old('expense_type_id') == $type->id ? 'selected' : ''); ?>><?php echo e($type->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="details" class="form-label">Details</label>
                            <input type="text" class="form-control" id="details" name="details" value="<?php echo e(old('details')); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="reference" class="form-label">Reference</label>
                            <input type="text" class="form-control" id="reference" name="reference" value="<?php echo e(old('reference')); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">Notes</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Create Transaction</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function togglePaymentFields() {
        var method = document.getElementById('payment_method').value;
        var bankField = document.getElementById('bank_account_field');
        var digitalField = document.getElementById('digital_payment_field');
        var bankSelect = document.getElementById('bank_account_id');
        var digitalSelect = document.getElementById('digital_payment_id');

        bankField.style.display = (method === 'bank') ? 'block' : 'none';
        digitalField.style.display = (method === 'digital') ? 'block' : 'none';

        bankSelect.required = (method === 'bank');
        digitalSelect.required = (method === 'digital');
    }

    function toggleTypeField() {
        var type = document.getElementById('type').value;
        var expenseField = document.getElementById('expense_type_field');
        var expenseSelect = document.getElementById('expense_type_id');

        expenseField.style.display = (type === 'expense') ? 'block' : 'none';
        expenseSelect.required = (type === 'expense');
    }

    document.getElementById('payment_method').addEventListener('change', togglePaymentFields);
    document.getElementById('type').addEventListener('change', toggleTypeField);

    // Initialize visibility based on old input
    window.addEventListener('DOMContentLoaded', function() {
        togglePaymentFields();
        toggleTypeField();
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/transactions/create.blade.php ENDPATH**/ ?>