<?php $__env->startSection('page-title', 'Balance Sheet Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Balance Sheet</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('reports.balance-sheet')); ?>" class="row g-3">
                <div class="col-md-8">
                    <label for="as_at" class="form-label">As At</label>
                    <input type="date" class="form-control" id="as_at" name="as_at" value="<?php echo e($asAt); ?>">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <!-- Assets -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Assets</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Cash in Hand</td>
                            <td class="text-end"><?php echo e(number_format($cashBalance, 2)); ?></td>
                        </tr>
                        <tr>
                            <td colspan="2"><strong>Bank Accounts</strong></td>
                        </tr>
                        <?php $__empty_1 = true; $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="ps-4"><?php echo e($account['name']); ?></td>
                                <td class="text-end"><?php echo e(number_format($account['balance'], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="2" class="text-center">No bank accounts</td></tr>
                        <?php endif; ?>
                        <tr>
                            <td><strong>Total Bank Balance</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalBankBalance, 2)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="2"><strong>Digital Accounts</strong></td>
                        </tr>
                        <?php $__empty_1 = true; $__currentLoopData = $digitalAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="ps-4"><?php echo e($account['name']); ?></td>
                                <td class="text-end"><?php echo e(number_format($account['balance'], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="2" class="text-center">No digital accounts</td></tr>
                        <?php endif; ?>
                        <tr>
                            <td><strong>Total Digital Balance</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalDigitalBalance, 2)); ?></strong></td>
                        </tr>
                        <tr>
                            <td>Accounts Receivable</td>
                            <td class="text-end"><?php echo e(number_format($accountsReceivable, 2)); ?></td>
                        </tr>
                        <tr>
                            <td>Inventory Value</td>
                            <td class="text-end"><?php echo e(number_format($inventoryValue, 2)); ?></td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Assets</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalAssets, 2)); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Liabilities & Equity -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">Liabilities</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Accounts Payable</td>
                            <td class="text-end"><?php echo e(number_format($accountsPayable, 2)); ?></td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Liabilities</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalLiabilities, 2)); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Equity</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Retained Earnings</td>
                            <td class="text-end"><?php echo e(number_format($retainedEarnings, 2)); ?></td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Equity</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalEquity, 2)); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">Summary</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td><strong>Total Liabilities and Equity</strong></td>
                            <td class="text-end"><strong><?php echo e(number_format($totalLiabilitiesAndEquity, 2)); ?></strong></td>
                        </tr>
                        <tr class="<?php echo e($totalAssets == $totalLiabilitiesAndEquity ? 'table-success' : 'table-danger'); ?>">
                            <td><strong>Balance Check</strong></td>
                            <td class="text-end">
                                <strong>
                                    <?php if($totalAssets == $totalLiabilitiesAndEquity): ?>
                                        Balanced ✓
                                    <?php else: ?>
                                        Not Balanced ✗
                                    <?php endif; ?>
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\startup sabbir\Desktop\jannat\accounting-system\resources\views/reports/balance-sheet.blade.php ENDPATH**/ ?>