<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\DigitalPaymentController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ExpenseTypeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\SalesDashboardController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SegmentController;
use App\Http\Controllers\ParticularController;

// Guest routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login']);
    Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [RegisterController::class, 'register']);
});

// Authenticated routes
Route::middleware('auth')->group(function () {
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('home');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Bank Accounts
    Route::resource('bank-accounts', BankAccountController::class);

    // Digital Payments
    Route::resource('digital-payments', DigitalPaymentController::class);

    // Cash management
    Route::get('/cash', [TransactionController::class, 'cashIndex'])->name('cash.index');

    // Transactions
    Route::resource('transactions', TransactionController::class);

    // Expenses
    Route::resource('expenses', ExpenseController::class);

    // Expense Types
    Route::resource('expense-types', ExpenseTypeController::class);

    // Particulars
    Route::resource('particulars', ParticularController::class);

    // Products
    Route::resource('products', ProductController::class);

    // Stock Management
    Route::get('/stock', [ProductController::class, 'stockIndex'])->name('stock.index');
    Route::post('/stock/adjust', [ProductController::class, 'adjustStock'])->name('stock.adjust');

    // Invoices
    Route::resource('invoices', InvoiceController::class);
    // Sales Dashboard
    Route::resource('sales-dashboard', SalesDashboardController::class);
    // Segments
    Route::resource('segments', SegmentController::class);
    Route::get('/invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('invoices.print');

    // Reports
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/profit-loss', [ReportController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/balance-sheet', [ReportController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/cash-book', [ReportController::class, 'cashBook'])->name('cash-book');
        Route::get('/bank-book', [ReportController::class, 'bankBook'])->name('bank-book');
        Route::get('/sales', [ReportController::class, 'salesReport'])->name('sales');
        Route::get('/receivable-payable', [ReportController::class, 'receivablePayable'])->name('receivable-payable');
    });

    // Admin routes
    Route::middleware('admin')->prefix('admin')->name('admin.')->group(function () {
        Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        Route::get('/users', [AdminController::class, 'users'])->name('users');
        Route::get('/users/{user}', [AdminController::class, 'userDetails'])->name('user-details');
        Route::get('/reports', [AdminController::class, 'reports'])->name('reports');
    });

    // Profile & Settings (simple placeholders)
    Route::get('/profile', function () {
        return view('profile');
    })->name('profile');

    Route::get('/settings', function () {
        return view('settings');
    })->name('settings');
});
