@extends('layouts.app')

@section('page-title', 'Transaction Details')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="{{ route('transactions.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Transactions
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header">
                    <h5>Transaction Details</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th>Date:</th>
                            <td>{{ $transaction->date->format('M d, Y') }}</td>
                        </tr>
                        <tr>
                            <th>Type:</th>
                            <td>
                                <span class="badge bg-{{ $transaction->type == 'income' ? 'success' : 'danger' }}">
                                    {{ ucfirst($transaction->type) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Amount:</th>
                            <td>{{ number_format($transaction->amount, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Payment Method:</th>
                            <td>{{ ucfirst($transaction->payment_method) }}</td>
                        </tr>
                        @if($transaction->bankAccount)
                        <tr>
                            <th>Bank Account:</th>
                            <td>{{ $transaction->bankAccount->bank_name }} - {{ $transaction->bankAccount->account_name }}</td>
                        </tr>
                        @endif
                        @if($transaction->digitalPayment)
                        <tr>
                            <th>Digital Payment:</th>
                            <td>{{ $transaction->digitalPayment->provider }}</td>
                        </tr>
                        @endif
                        @if($transaction->expenseType)
                        <tr>
                            <th>Expense Type:</th>
                            <td>{{ $transaction->expenseType->name }}</td>
                        </tr>
                        @endif
                        <tr>
                            <th>Balance Before:</th>
                            <td>{{ number_format($transaction->balance_before, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Balance After:</th>
                            <td>{{ number_format($transaction->balance_after, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Details:</th>
                            <td>{{ $transaction->details ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Reference:</th>
                            <td>{{ $transaction->reference ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Notes:</th>
                            <td>{{ $transaction->notes ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
