@extends('layouts.app')

@section('page-title', 'Add Transaction')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Add New Transaction</h4>
                </div>
                <div class="card-body">

                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('transactions.store') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date" class="form-label">Date *</label>
                                    <input type="date" class="form-control" id="date" name="date" value="{{ old('date', now()->toDateString()) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">Type *</label>
                                        <select class="form-select" id="type" name="type" required>
                                            <option value="">Select Type</option>
                                            <option value="income" {{ old('type')=='income' ? 'selected' : '' }}>Income</option>
                                            <option value="expense" {{ old('type')=='expense' ? 'selected' : '' }}>Expense</option>
                                        </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="payment_method" class="form-label">Payment Method *</label>
                                        <select class="form-select" id="payment_method" name="payment_method" required>
                                            <option value="">Select Method</option>
                                            <option value="cash" {{ old('payment_method')=='cash' ? 'selected' : '' }}>Cash</option>
                                            <option value="bank" {{ old('payment_method')=='bank' ? 'selected' : '' }}>Bank</option>
                                            <option value="digital" {{ old('payment_method')=='digital' ? 'selected' : '' }}>Digital</option>
                                        </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="amount" class="form-label">Amount *</label>
                                    <input type="number" class="form-control" id="amount" name="amount" step="0.01" min="0.01" value="{{ old('amount') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3" id="bank_account_field" style="display: none;">
                            <label for="bank_account_id" class="form-label">Bank Account</label>
                            <select class="form-select" id="bank_account_id" name="bank_account_id">
                                <option value="">Select Account</option>
                                @foreach($bankAccounts as $account)
                                    <option value="{{ $account->id }}" {{ old('bank_account_id') == $account->id ? 'selected' : '' }}>{{ $account->bank_name }} - {{ $account->account_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3" id="digital_payment_field" style="display: none;">
                            <label for="digital_payment_id" class="form-label">Digital Payment</label>
                            <select class="form-select" id="digital_payment_id" name="digital_payment_id">
                                <option value="">Select Account</option>
                                @foreach($digitalPayments as $payment)
                                    <option value="{{ $payment->id }}" {{ old('digital_payment_id') == $payment->id ? 'selected' : '' }}>{{ $payment->provider }} - {{ $payment->account_number }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3" id="expense_type_field" style="display: none;">
                            <label for="expense_type_id" class="form-label">Expense Type</label>
                            <select class="form-select" id="expense_type_id" name="expense_type_id">
                                <option value="">Select Type</option>
                                @foreach($expenseTypes as $type)
                                    <option value="{{ $type->id }}" {{ old('expense_type_id') == $type->id ? 'selected' : '' }}>{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="details" class="form-label">Details</label>
                            <input type="text" class="form-control" id="details" name="details" value="{{ old('details') }}">
                        </div>

                        <div class="mb-3">
                            <label for="reference" class="form-label">Reference</label>
                            <input type="text" class="form-control" id="reference" name="reference" value="{{ old('reference') }}">
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">Notes</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('transactions.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Create Transaction</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function togglePaymentFields() {
        var method = document.getElementById('payment_method').value;
        var bankField = document.getElementById('bank_account_field');
        var digitalField = document.getElementById('digital_payment_field');
        var bankSelect = document.getElementById('bank_account_id');
        var digitalSelect = document.getElementById('digital_payment_id');

        bankField.style.display = (method === 'bank') ? 'block' : 'none';
        digitalField.style.display = (method === 'digital') ? 'block' : 'none';

        bankSelect.required = (method === 'bank');
        digitalSelect.required = (method === 'digital');
    }

    function toggleTypeField() {
        var type = document.getElementById('type').value;
        var expenseField = document.getElementById('expense_type_field');
        var expenseSelect = document.getElementById('expense_type_id');

        expenseField.style.display = (type === 'expense') ? 'block' : 'none';
        expenseSelect.required = (type === 'expense');
    }

    document.getElementById('payment_method').addEventListener('change', togglePaymentFields);
    document.getElementById('type').addEventListener('change', toggleTypeField);

    // Initialize visibility based on old input
    window.addEventListener('DOMContentLoaded', function() {
        togglePaymentFields();
        toggleTypeField();
    });
</script>
@endsection
