@extends('layouts.app')

@section('page-title', 'Segments')

@section('content')
<div class="container-fluid">
	<div class="row mb-4">
		<div class="col-md-6">
			<h2>Segments</h2>
		</div>
		<div class="col-md-6 text-end">
			<a href="{{ route('segments.create') }}" class="btn btn-primary">
				<i class="fas fa-plus"></i> Add Segment
			</a>
		</div>
	</div>

	@if(session('success'))
		<div class="alert alert-success">{{ session('success') }}</div>
	@endif
	@if(session('error'))
		<div class="alert alert-danger">{{ session('error') }}</div>
	@endif

	<div class="row">
		<div class="col-12">
			@if($segments->isEmpty())
				<div class="alert alert-info">No segments found. <a href="{{ route('segments.create') }}">Create one</a>.</div>
			@else
				<div class="table-responsive">
					<table class="table table-striped table-bordered">
						<thead>
							<tr>
								<th>Name</th>
								<th>Description</th>
								<th class="text-end">Actions</th>
							</tr>
						</thead>
						<tbody>
							@foreach($segments as $segment)
								<tr>
									<td>{{ $segment->name }}</td>
									<td>{{ $segment->description ?? '-' }}</td>
									<td class="text-end">
										<a href="{{ route('segments.edit', $segment->id) }}" class="btn btn-sm btn-primary">
											<i class="fas fa-edit"></i> Edit
										</a>
										<form action="{{ route('segments.destroy', $segment->id) }}" method="POST" class="d-inline">
											@csrf
											@method('DELETE')
											<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this segment?')">
												<i class="fas fa-trash"></i> Delete
											</button>
										</form>
									</td>
								</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			@endif
		</div>
	</div>
</div>
@endsection
