@extends('layouts.app')

@section('page-title', 'Create Segment')

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-md-8 offset-md-2">
			<div class="card">
				<div class="card-header">
					<h4>Create New Segment</h4>
				</div>
				<div class="card-body">
					<form action="{{ route('segments.store') }}" method="POST">
						@csrf

						<div class="mb-3">
							<label for="name" class="form-label">Name *</label>
							<input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
							@error('name')
								<div class="invalid-feedback">{{ $message }}</div>
							@enderror
						</div>

						<div class="mb-3">
							<label for="description" class="form-label">Description</label>
							<textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
							@error('description')
								<div class="invalid-feedback">{{ $message }}</div>
							@enderror
						</div>

						<div class="d-flex justify-content-between">
							<a href="{{ route('segments.index') }}" class="btn btn-secondary">Cancel</a>
							<button type="submit" class="btn btn-primary">Create Segment</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
