@extends('layouts.app')

@section('page-title', 'Sales Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Sales Dashboard</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('sales-dashboard.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Record
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-sm">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Invoice</th>
                            <th>Product</th>
                            <th>QTY</th>
                            <th>Sales</th>
                            <th>Particulars</th>
                            <th>Payment</th>
                            <th>Due</th>
                            <th>COGS</th>
                            <th>Gross Profit</th>
                            <th>%</th>
                            <th>Cash Received By</th>
                            <th>Segment</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalSales = $salesDashboards->sum('sales');
                            $totalPayment = $salesDashboards->sum('payment');
                            $totalDue = $salesDashboards->sum('due');
                            $totalCogs = $salesDashboards->sum('cogs');
                            $totalGross = $salesDashboards->sum('gross_profit');
                            $totalAmount = $salesDashboards->sum('amount');
                        @endphp

                        @forelse($salesDashboards as $record)
                            <tr>
                                <td>{{ $record->date ? $record->date->format('Y-m-d') : '-' }}</td>
                                <td>{{ $record->invoice ?? '-' }}</td>
                                <td>{{ $record->product ?? '-' }}</td>
                                <td>{{ $record->qty ?? '-' }}</td>
                                <td>{{ $record->sales ? number_format($record->sales, 2) : '-' }}</td>
                                <td>{{ $record->particulars ?? '-' }}</td>
                                <td>{{ $record->payment ? number_format($record->payment, 2) : '-' }}</td>
                                <td>{{ $record->due ? number_format($record->due, 2) : '-' }}</td>
                                <td>{{ $record->cogs ? number_format($record->cogs, 2) : '-' }}</td>
                                <td>{{ $record->gross_profit ? number_format($record->gross_profit, 2) : '-' }}</td>
                                <td>{{ $record->percentage ? number_format($record->percentage, 2) : '-' }}</td>
                                <td>{{ $record->cash_received_by ?? '-' }}</td>
                                <td>{{ $record->segment ?? '-' }}</td>
                                <td>{{ $record->amount ? number_format($record->amount, 2) : '-' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="14" class="text-center">No records found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr class="fw-bold">
                            <td colspan="4">Total</td>
                            <td>{{ number_format($totalSales, 2) }}</td>
                            <td></td>
                            <td>{{ number_format($totalPayment, 2) }}</td>
                            <td>{{ number_format($totalDue, 2) }}</td>
                            <td>{{ number_format($totalCogs, 2) }}</td>
                            <td>{{ number_format($totalGross, 2) }}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>{{ number_format($totalAmount, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>

                {{-- Segment-wise and Day-wise summaries --}}
                @php
                    $segments = $salesDashboards->groupBy(function($r){ return $r->segment ?? 'Unspecified'; });
                    $dayGroups = $salesDashboards->groupBy(function($r){ return $r->date ? $r->date->format('Y-m-d') : 'No Date'; });
                @endphp

                <div class="row mt-4">
                    <div class="col-md-6">
                        <h5>Segment Wise Sales</h5>
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>Segment</th>
                                    <th>QTY</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($segments as $segment => $rows)
                                    <tr>
                                        <td>{{ $segment }}</td>
                                        <td>{{ $rows->sum('qty') }}</td>
                                        <td>{{ number_format($rows->sum('amount'), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h5>Day Wise Sales</h5>
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Qty</th>
                                    <th>Amount</th>
                                    <th>COGS</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($dayGroups as $day => $rows)
                                    <tr>
                                        <td>{{ $day }}</td>
                                        <td>{{ $rows->sum('qty') }}</td>
                                        <td>{{ number_format($rows->sum('sales'), 2) }}</td>
                                        <td>{{ number_format($rows->sum('cogs'), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
