@extends('layouts.app')

@section('page-title', 'Edit Sales Dashboard Record')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Edit Sales Dashboard Record</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('sales-dashboard.update', $salesDashboard->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="date" class="form-label">Date</label>
                                <input type="date" class="form-control" id="date" name="date" value="{{ old('date', $salesDashboard->date) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="invoice" class="form-label">Invoice</label>
                                <input type="text" class="form-control" id="invoice" name="invoice" value="{{ old('invoice', $salesDashboard->invoice) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="product" class="form-label">Product</label>
                                <input type="text" class="form-control" id="product" name="product" value="{{ old('product', $salesDashboard->product) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="qty" class="form-label">Quantity</label>
                                <input type="number" class="form-control" id="qty" name="qty" value="{{ old('qty', $salesDashboard->qty) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="sales" class="form-label">Sales</label>
                                <input type="number" step="0.01" class="form-control" id="sales" name="sales" value="{{ old('sales', $salesDashboard->sales) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="particulars" class="form-label">Particulars</label>
                                <input type="text" class="form-control" id="particulars" name="particulars" value="{{ old('particulars', $salesDashboard->particulars) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="payment" class="form-label">Payment</label>
                                <input type="number" step="0.01" class="form-control" id="payment" name="payment" value="{{ old('payment', $salesDashboard->payment) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="payment_method" class="form-label">Cash Received By</label>
                                <select class="form-select" id="payment_method" name="payment_method">
                                    <option value="">Select Method</option>
                                    <option value="cash" {{ old('payment_method', $salesDashboard->payment_method) == 'cash' ? 'selected' : '' }}>Cash</option>
                                    <option value="bank" {{ old('payment_method', $salesDashboard->payment_method) == 'bank' ? 'selected' : '' }}>Bank</option>
                                    <option value="digital" {{ old('payment_method', $salesDashboard->payment_method) == 'digital' ? 'selected' : '' }}>Digital</option>
                                </select>
                            </div>
                        </div>

                        <div class="mb-3" id="bank_account_field" style="display: none;">
                            <label for="bank_account_id" class="form-label">Bank Account</label>
                            <select class="form-select" id="bank_account_id" name="bank_account_id">
                                <option value="">Select Account</option>
                                @foreach($bankAccounts ?? [] as $account)
                                    <option value="{{ $account->id }}" {{ old('bank_account_id', $salesDashboard->bank_account_id) == $account->id ? 'selected' : '' }}>{{ $account->bank_name }} - {{ $account->account_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3" id="digital_payment_field" style="display: none;">
                            <label for="digital_payment_id" class="form-label">Digital Payment</label>
                            <select class="form-select" id="digital_payment_id" name="digital_payment_id">
                                <option value="">Select Account</option>
                                @foreach($digitalPayments ?? [] as $payment)
                                    <option value="{{ $payment->id }}" {{ old('digital_payment_id', $salesDashboard->digital_payment_id) == $payment->id ? 'selected' : '' }}>{{ $payment->provider }} - {{ $payment->account_number }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="due" class="form-label">Due</label>
                                <input type="number" step="0.01" class="form-control" id="due" name="due" value="{{ old('due', $salesDashboard->due) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="cogs" class="form-label">COGS</label>
                                <input type="number" step="0.01" class="form-control" id="cogs" name="cogs" value="{{ old('cogs', $salesDashboard->cogs) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="gross_profit" class="form-label">Gross Profit</label>
                                <input type="number" step="0.01" class="form-control" id="gross_profit" name="gross_profit" value="{{ old('gross_profit', $salesDashboard->gross_profit) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="percentage" class="form-label">Percentage</label>
                                <input type="number" step="0.01" class="form-control" id="percentage" name="percentage" value="{{ old('percentage', $salesDashboard->percentage) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="cash_received_by" class="form-label">Cash Received By</label>
                                <input type="text" class="form-control" id="cash_received_by" name="cash_received_by" value="{{ old('cash_received_by', $salesDashboard->cash_received_by) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="segment" class="form-label">Segment</label>
                                <input type="text" class="form-control" id="segment" name="segment" value="{{ old('segment', $salesDashboard->segment) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="amount" class="form-label">Amount</label>
                                <input type="number" step="0.01" class="form-control" id="amount" name="amount" value="{{ old('amount', $salesDashboard->amount) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="kpi" class="form-label">KPI</label>
                                <input type="number" step="0.01" class="form-control" id="kpi" name="kpi" value="{{ old('kpi', $salesDashboard->kpi) }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="revenue" class="form-label">Revenue</label>
                                <input type="number" step="0.01" class="form-control" id="revenue" name="revenue" value="{{ old('revenue', $salesDashboard->revenue) }}">
                            </div>
                            <div class="col-md-6">
                                <label for="achiv" class="form-label">Achievement (%)</label>
                                <input type="number" step="0.01" class="form-control" id="achiv" name="achiv" value="{{ old('achiv', $salesDashboard->achiv) }}">
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('sales-dashboard.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>

                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const paymentMethodSelect = document.getElementById('payment_method');
                            const bankAccountField = document.getElementById('bank_account_field');
                            const digitalPaymentField = document.getElementById('digital_payment_field');

                            function togglePaymentFields() {
                                const method = paymentMethodSelect.value;
                                if (bankAccountField) {
                                    bankAccountField.style.display = (method === 'bank') ? 'block' : 'none';
                                }
                                if (digitalPaymentField) {
                                    digitalPaymentField.style.display = (method === 'digital') ? 'block' : 'none';
                                }
                            }

                            paymentMethodSelect?.addEventListener('change', togglePaymentFields);
                            togglePaymentFields();
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
