@extends('layouts.app')

@section('page-title', 'Receivable & Payable Report')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Receivable & Payable Report</h2>
        </div>
    </div>

    <div class="row">
        <!-- Accounts Receivable -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Accounts Receivable</h5>
                </div>
                <div class="card-body">
                    @php
                        $receivables = \App\Models\Invoice::where('user_id', auth()->id())
                            ->where('status', '!=', 'paid')
                            ->where('due', '>', 0)
                            ->with('customer')
                            ->get();
                        $totalReceivable = $receivables->sum('due');
                    @endphp

                    @if($receivables->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Invoice #</th>
                                        <th>Customer</th>
                                        <th>Due Date</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($receivables as $invoice)
                                        <tr>
                                            <td>{{ $invoice->id }}</td>
                                            <td>{{ $invoice->customer->name ?? '-' }}</td>
                                            <td>{{ $invoice->due_date ? $invoice->due_date->format('M d, Y') : '-' }}</td>
                                            <td>{{ number_format($invoice->due, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr class="table-success">
                                        <th colspan="3">Total Receivable</th>
                                        <th>{{ number_format($totalReceivable, 2) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <p class="text-center text-success">No outstanding receivables!</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Accounts Payable -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">Accounts Payable</h5>
                </div>
                <div class="card-body">
                    <p class="text-center text-muted">No payable tracking implemented yet.</p>
                    <div class="alert alert-info">
                        <small>To enable payable tracking, you need to implement purchase management.</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
