@extends('layouts.app')

@section('page-title', 'Profit & Loss Report')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Profit & Loss Report</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('reports.profit-loss') }}" class="row g-3">
                <div class="col-md-4">
                    <label for="year" class="form-label">Year</label>
                    <select class="form-select" id="year" name="year">
                        @for($y = now()->year; $y >= now()->year - 5; $y--)
                            <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                        @endfor
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="month" class="form-label">Month</label>
                    <select class="form-select" id="month" name="month">
                        @for($m = 1; $m <= 12; $m++)
                            <option value="{{ $m }}" {{ $month == $m ? 'selected' : '' }}>
                                {{ Carbon\Carbon::create()->month($m)->format('F') }}
                            </option>
                        @endfor
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Total Income</h5>
                    <h3>{{ number_format($income, 2) }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Expenses</h5>
                    <h3>{{ number_format($expenses, 2) }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-{{ $netProfit >= 0 ? 'success' : 'danger' }} text-white">
                <div class="card-body">
                    <h5>Net Profit</h5>
                    <h3>{{ number_format($netProfit, 2) }}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Expense Breakdown -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expense Breakdown by Type</h5>
                </div>
                <div class="card-body">
                    @if($expenseBreakdown->count() > 0)
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($expenseBreakdown as $item)
                                    <tr>
                                        <td>{{ $item->expenseType->name ?? 'Unknown' }}</td>
                                        <td>{{ number_format($item->total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-center">No expenses recorded.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Segment-wise Expenses -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Segment-wise Expenses</h5>
                </div>
                <div class="card-body">
                    @if($segmentExpenses->count() > 0)
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Segment</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($segmentExpenses as $item)
                                    <tr>
                                        <td>{{ $item->segment->name ?? 'Unknown' }}</td>
                                        <td>{{ number_format($item->total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-center">No segment expenses recorded.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
