@extends('layouts.app')

@section('page-title', 'Bank Book Report')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Bank Book</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('reports.bank-book') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="bank_account_id" class="form-label">Bank Account</label>
                    <select class="form-select" id="bank_account_id" name="bank_account_id">
                        <option value="">All Accounts</option>
                        @foreach($bankAccounts as $account)
                            <option value="{{ $account->id }}" {{ $bankAccountId == $account->id ? 'selected' : '' }}>
                                {{ $account->bank_name }} - {{ $account->account_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="{{ $fromDate }}">
                </div>
                <div class="col-md-3">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="{{ $toDate }}">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5>Opening Balance</h5>
                    <h4>{{ number_format($openingBalance, 2) }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Total Deposits</h5>
                    <h4>{{ number_format($totalDeposits, 2) }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Withdrawals</h5>
                    <h4>{{ number_format($totalWithdrawals, 2) }}</h4>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5>Closing Balance</h5>
                    <h4>{{ number_format($closingBalance, 2) }}</h4>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Account</th>
                            <th>Details</th>
                            <th>Deposits</th>
                            <th>Withdrawals</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction->date->format('M d, Y') }}</td>
                                <td>
                                    <span class="badge bg-{{ $transaction->type == 'income' ? 'success' : 'danger' }}">
                                        {{ ucfirst($transaction->type) }}
                                    </span>
                                </td>
                                <td>{{ $transaction->bankAccount->bank_name ?? '-' }}</td>
                                <td>{{ $transaction->details ?? '-' }}</td>
                                <td>{{ $transaction->type == 'income' ? number_format($transaction->amount, 2) : '-' }}</td>
                                <td>{{ $transaction->type == 'expense' ? number_format($transaction->amount, 2) : '-' }}</td>
                                <td>{{ number_format($transaction->balance_after, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No transactions found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
