@extends('layouts.app')

@section('page-title', 'Balance Sheet Report')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Balance Sheet</h2>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('reports.balance-sheet') }}" class="row g-3">
                <div class="col-md-8">
                    <label for="as_at" class="form-label">As At</label>
                    <input type="date" class="form-control" id="as_at" name="as_at" value="{{ $asAt }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Generate Report</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <!-- Assets -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Assets</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Cash in Hand</td>
                            <td class="text-end">{{ number_format($cashBalance, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="2"><strong>Bank Accounts</strong></td>
                        </tr>
                        @forelse($bankAccounts as $account)
                            <tr>
                                <td class="ps-4">{{ $account['name'] }}</td>
                                <td class="text-end">{{ number_format($account['balance'], 2) }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="2" class="text-center">No bank accounts</td></tr>
                        @endforelse
                        <tr>
                            <td><strong>Total Bank Balance</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalBankBalance, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td colspan="2"><strong>Digital Accounts</strong></td>
                        </tr>
                        @forelse($digitalAccounts as $account)
                            <tr>
                                <td class="ps-4">{{ $account['name'] }}</td>
                                <td class="text-end">{{ number_format($account['balance'], 2) }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="2" class="text-center">No digital accounts</td></tr>
                        @endforelse
                        <tr>
                            <td><strong>Total Digital Balance</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalDigitalBalance, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td>Accounts Receivable</td>
                            <td class="text-end">{{ number_format($accountsReceivable, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Inventory Value</td>
                            <td class="text-end">{{ number_format($inventoryValue, 2) }}</td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Assets</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalAssets, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Liabilities & Equity -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">Liabilities</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Accounts Payable</td>
                            <td class="text-end">{{ number_format($accountsPayable, 2) }}</td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Liabilities</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalLiabilities, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Equity</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td>Retained Earnings</td>
                            <td class="text-end">{{ number_format($retainedEarnings, 2) }}</td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>Total Equity</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalEquity, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">Summary</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td><strong>Total Liabilities and Equity</strong></td>
                            <td class="text-end"><strong>{{ number_format($totalLiabilitiesAndEquity, 2) }}</strong></td>
                        </tr>
                        <tr class="{{ $totalAssets == $totalLiabilitiesAndEquity ? 'table-success' : 'table-danger' }}">
                            <td><strong>Balance Check</strong></td>
                            <td class="text-end">
                                <strong>
                                    @if($totalAssets == $totalLiabilitiesAndEquity)
                                        Balanced ✓
                                    @else
                                        Not Balanced ✗
                                    @endif
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
