@extends('layouts.app')

@section('page-title', 'Products')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Products</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('products.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Product
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>SKU</th>
                            <th>Unit</th>
                            <th>Current Stock</th>
                            <th>Min Stock</th>
                            <th>total purchase price</th>
                            <th>Purchase Price</th>
                            <th>Sales Price</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($products as $product)
                            <tr>
                                <td>{{ $product->name }}</td>
                                <td>{{ $product->sku ?? '-' }}</td>
                                <td>{{ $product->unit ?? '-' }}</td>
                                <td>
                                    @if($product->current_stock <= $product->minimum_stock)
                                        <span class="badge bg-danger">{{ $product->current_stock }}</span>
                                    @else
                                        {{ $product->current_stock }}
                                    @endif
                                </td>
                                <td>{{ $product->minimum_stock }}</td>
                                <td>{{ number_format($product->total_purchase_price, 2) }}</td>
                                <td>{{ number_format($product->purchase_price, 2) }}</td>
                                <td>{{ number_format($product->sales_price, 2) }}</td>
                                <td>
                                    <a href="{{ route('products.edit', $product->id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('products.destroy', $product->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">No products found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
