@extends('layouts.app')

@section('page-title', 'Add Product')

@section('content')
<script>
function togglePaymentFields() {
    const method = document.getElementById('payment_method').value;
    const bankSection = document.getElementById('bank_account_section');
    const digitalSection = document.getElementById('digital_payment_section');
    const totalCostSection = document.getElementById('total_cost');

    if (method === 'bank') {
        bankSection.style.display = 'block';
        digitalSection.style.display = 'none';
        document.getElementById('digital_payment_id').value = '';
    } else if (method === 'digital') {
        bankSection.style.display = 'none';
        digitalSection.style.display = 'block';
        document.getElementById('bank_account_id').value = '';
    } else {
        bankSection.style.display = 'none';
        digitalSection.style.display = 'none';
        totalCostSection.style.display = 'none';
    }

    calculateTotal();
}

function calculateTotal() {
    const purchasePrice = parseFloat(document.getElementById('purchase_price').value) || 0;
    const currentStock = parseInt(document.getElementById('current_stock').value) || 0;
    const totalCost = purchasePrice * currentStock;

    const totalCostSection = document.getElementById('total_cost');
    const costAmount = document.getElementById('cost_amount');

    if (totalCost > 0 && document.getElementById('payment_method').value) {
        costAmount.textContent = totalCost.toFixed(2);
        totalCostSection.style.display = 'block';
    } else {
        totalCostSection.style.display = 'none';
    }
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('purchase_price').addEventListener('input', calculateTotal);
    document.getElementById('current_stock').addEventListener('input', calculateTotal);
});
</script>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Add New Product</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('products.store') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name *</label>
                                    <input type="text" class="form-control" id="name" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="sku" class="form-label">SKU</label>
                                    <input type="text" class="form-control" id="sku" name="sku">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="2"></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="unit" class="form-label">Unit</label>
                                    <input type="text" class="form-control" id="unit" name="unit" placeholder="e.g., pcs, kg, box">
                                </div>
                            </div>
                            <div class="col-md-6">
                               <div class="mb-3">
                                    <label for="minimum_stock" class="form-label">Minimum Stock</label>
                                    <input type="number" class="form-control" id="minimum_stock" name="minimum_stock" min="0" value="{{ $product->minimum_stock }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="current_stock" class="form-label">Current Stock</label>
                                    <input type="number" class="form-control" id="current_stock" name="current_stock" min="0" value="{{ $product->current_stock }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="purchase_price" class="form-label">Purchase Price</label>
                                    <input type="number" class="form-control" id="purchase_price" name="purchase_price" step="0.01" min="0" value="{{ $product->purchase_price }}">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="sales_price" class="form-label">Sales Price</label>
                            <input type="number" class="form-control" id="sales_price" name="sales_price" step="0.01" min="0" value="{{ $product->sales_price ?? 0 }}">
                        </div>
                        <hr>
                        <h5>Payment Method (For Purchase)</h5>

                        <div class="mb-3">
                            <label for="payment_method" class="form-label">Select Payment Method *</label>
                            <select class="form-control" id="payment_method" name="payment_method" required onchange="togglePaymentFields()">
                                <option value="">-- Choose Payment Method --</option>
                                <option value="bank">Bank Account</option>
                                <option value="digital">Digital Payment</option>
                            </select>
                        </div>

                        <div id="bank_account_section" style="display:none;" class="mb-3">
                            <label for="bank_account_id" class="form-label">Select Bank Account</label>
                            <select class="form-control" id="bank_account_id" name="bank_account_id">
                                <option value="">-- Choose Bank Account --</option>
                                @foreach($bankAccounts as $account)
                                    <option value="{{ $account->id }}" data-balance="{{ $account->balance }}">
                                        {{ $account->account_name }} - {{ $account->bank_name }} (Balance: {{ $account->balance }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div id="digital_payment_section" style="display:none;" class="mb-3">
                            <label for="digital_payment_id" class="form-label">Select Digital Payment</label>
                            <select class="form-control" id="digital_payment_id" name="digital_payment_id">
                                <option value="">-- Choose Digital Payment --</option>
                                @foreach($digitalPayments as $payment)
                                    <option value="{{ $payment->id }}" data-balance="{{ $payment->balance }}">
                                        {{ $payment->provider }} - {{ $payment->account_number }} (Balance: {{ $payment->balance }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="alert alert-info" id="total_cost" style="display:none;">
                            <strong>Total Purchase Cost:</strong> <span id="cost_amount">0.00</span>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('products.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Create Product</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
