@if(session('success'))
    <div style="color:green">{{ session('success') }}</div>
@endif

<h1>Particulars</h1>

<p><a href="{{ route('particulars.create') }}">Create New Particular</a></p>

@if($particulars->isEmpty())
    <p>No particulars found.</p>
@else
    <ul>
        @foreach($particulars as $p)
            <li>
                <a href="{{ route('particulars.show', $p->id) }}">{{ $p->particulars }}</a>
                — <a href="{{ route('particulars.edit', $p->id) }}">Edit</a>
                <form action="{{ route('particulars.destroy', $p->id) }}" method="POST" style="display:inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" onclick="return confirm('Delete this particular?')">Delete</button>
                </form>
            </li>
        @endforeach
    </ul>
@endif
