@extends('layouts.app')

@section('page-title', 'Invoice Details')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="{{ route('invoices.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Invoices
            </a>
            <a href="{{ route('invoices.print', $invoice->id) }}" class="btn btn-primary" target="_blank">
                <i class="fas fa-print"></i> Print
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4>Invoice #{{ $invoice->id }}</h4>
                        @switch($invoice->status)
                            @case('pending')
                                <span class="badge bg-warning">Pending</span>
                                @break
                            @case('paid')
                                <span class="badge bg-success">Paid</span>
                                @break
                            @case('partial')
                                <span class="badge bg-info">Partial</span>
                                @break
                            @case('cancelled')
                                <span class="badge bg-danger">Cancelled</span>
                                @break
                        @endswitch
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <p><strong>Customer:</strong> {{ $invoice->customer->name ?? '-' }}</p>
                            <p><strong>Invoice Date:</strong> {{ $invoice->invoice_date->format('M d, Y') }}</p>
                            @if($invoice->due_date)
                                <p><strong>Due Date:</strong> {{ $invoice->due_date->format('M d, Y') }}</p>
                            @endif
                        </div>
                        <div class="col-md-6 text-end">
                            <h3>Total: {{ number_format($invoice->total_amount, 2) }}</h3>
                        </div>
                    </div>

                    <h5>Items</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Unit Price</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoice->items as $item)
                                    <tr>
                                        <td>{{ $item->product->name ?? '-' }}</td>
                                        <td>{{ $item->quantity }}</td>
                                        <td>{{ number_format($item->unit_price, 2) }}</td>
                                        <td>{{ number_format($item->subtotal, 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">No items found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="3" class="text-end">Total</th>
                                    <th>{{ number_format($invoice->total_amount, 2) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    @if($invoice->notes)
                        <div class="mt-4">
                            <p><strong>Notes:</strong></p>
                            <p>{{ $invoice->notes }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
