@extends('layouts.app')

@section('page-title', 'Expenses')
@extends('layouts.app')

@section('page-title', 'Expenses')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Expenses</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('expenses.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Expense
            </a>
        </div>
    </div>

    <!-- Summary Card -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5>Total Expenses</h5>
                    <h3>{{ number_format($totalAmount, 2) }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('expenses.index') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="{{ request('from_date') }}">
                </div>
                <div class="col-md-3">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="{{ request('to_date') }}">
                </div>
                <div class="col-md-3">
                    <label for="expense_type_id" class="form-label">Expense Type</label>
                    <select class="form-select" id="expense_type_id" name="expense_type_id">
                        <option value="">All Types</option>
                        @foreach($expenseTypes as $type)
                            <option value="{{ $type->id }}" {{ request('expense_type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filter</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Expenses Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Segment</th>
                            <th>Amount</th>
                            <th>Payment Method</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($expenses as $expense)
                            <tr>
                                <td>{{ $expense->date->format('M d, Y') }}</td>
                                <td>{{ $expense->expenseType->name ?? '-' }}</td>
                                <td>{{ $expense->segment->name ?? '-' }}</td>
                                <td>{{ number_format($expense->amount, 2) }}</td>
                                <td>{{ ucfirst($expense->payment_method) }}</td>
                                <td>{{ $expense->description ?? '-' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No expenses recorded.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $expenses->links() }}
        </div>
    </div>
</div>
@endsection
