@extends('layouts.app')

@section('page-title', 'Expense Types')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Expense Types</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('expense-types.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Type
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($expenseTypes as $type)
                            <tr>
                                <td>{{ $type->name }}</td>
                                <td>
                                    @if($type->is_system)
                                        <span class="badge bg-primary">System</span>
                                    @else
                                        <span class="badge bg-secondary">Custom</span>
                                    @endif
                                </td>
                                <td>
                                    @if(!$type->is_system || $type->user_id === auth()->id())
                                        <a href="{{ route('expense-types.edit', $type->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('expense-types.destroy', $type->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    @else
                                        <span class="text-muted">System Type</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center">No expense types found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
