@extends('layouts.app')

@section('page-title', 'Edit Expense Type')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header">
                    <h4>Edit Expense Type</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('expense-types.update', $expenseType->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="name" class="form-label">Name *</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $expenseType->name }}" required>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('expense-types.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
