@extends('layouts.app')

@section('page-title', 'Digital Payments')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Digital Payment Accounts</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('digital-payments.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Account
            </a>
        </div>
    </div>

    <div class="row">
        @forelse($accounts as $account)
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">{{ $account->provider }}</h5>
                        @if($account->is_active)
                            <span class="badge bg-success">Active</span>
                        @else
                            <span class="badge bg-secondary">Inactive</span>
                        @endif
                    </div>
                    <div class="card-body">
                        <p><strong>Account Name:</strong> {{ $account->account_name }}</p>
                        <p><strong>Account Number:</strong> {{ $account->account_number ?? 'N/A' }}</p>
                        <p><strong>Balance:</strong> {{ number_format($account->balance, 2) }}</p>
                        <p><strong>Transactions:</strong> {{ $account->transactions->count() }}</p>
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('digital-payments.edit', $account->id) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <form action="{{ route('digital-payments.destroy', $account->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="alert alert-info">
                    No digital payment accounts found. <a href="{{ route('digital-payments.create') }}">Add your first account</a>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection
