@extends('layouts.app')

@section('page-title', 'Edit Digital Payment Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Edit Digital Payment Account</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('digital-payments.update', $digitalPayment->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="provider" class="form-label">Provider *</label>
                            <input type="text" class="form-control" id="provider" name="provider" value="{{ $digitalPayment->provider }}" required>
                        </div>

                        <div class="mb-3">
                            <label for="account_name" class="form-label">Account Name *</label>
                            <input type="text" class="form-control" id="account_name" name="account_name" value="{{ $digitalPayment->account_name }}" required>
                        </div>

                        <div class="mb-3">
                            <label for="account_number" class="form-label">Account Number</label>
                            <input type="text" class="form-control" id="account_number" name="account_number" value="{{ $digitalPayment->account_number }}">
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $digitalPayment->is_active ? 'checked' : '' }}>
                                <label for="is_active" class="form-check-label">Active Account</label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('digital-payments.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Update Account</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
