{{-- resources/views/dashboard/user.blade.php --}}
@extends('layouts.app')

@section('page-title', 'User Dashboard')

@section('content')
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Today's Income</h6>
                    <h3 class="mb-0 text-success">৳{{ number_format($todayIncome, 2) }}</h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-arrow-up text-success"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Today's Expense</h6>
                    <h3 class="mb-0 text-danger">৳{{ number_format($todayExpense, 2) }}</h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-arrow-down text-danger"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Monthly Income</h6>
                    <h3 class="mb-0 text-success">৳{{ number_format($monthlyIncome, 2) }}</h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-calendar-alt text-info"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-2">Monthly Expense</h6>
                    <h3 class="mb-0 text-danger">৳{{ number_format($monthlyExpense, 2) }}</h3>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-calendar-alt text-info"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Account Balances</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="fw-bold">Cash Balance:</label>
                    <span class="text-success ms-2">৳{{ number_format($cashBalance, 2) }}</span>
                </div>

                @if($bankAccounts->count() > 0)
                    <h6 class="mt-3">Bank Accounts</h6>
                    <div class="list-group">
                        @foreach($bankAccounts as $account)
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $account->account_name }}</strong><br>
                                    <small class="text-muted">{{ $account->bank_name }}</small>
                                </div>
                                <span class="badge bg-success rounded-pill">৳{{ number_format($account->balance, 2) }}</span>
                            </div>
                        @endforeach
                    </div>
                @endif

                @if($digitalAccounts->count() > 0)
                    <h6 class="mt-3">Digital Payments</h6>
                    <div class="list-group">
                        @foreach($digitalAccounts as $account)
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $account->provider }}</strong><br>
                                    <small class="text-muted">{{ $account->account_number }}</small>
                                </div>
                                <span class="badge bg-info rounded-pill">৳{{ number_format($account->balance, 2) }}</span>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row g-2">
                    <div class="col-6">
                        <a href="{{ route('transactions.create') }}" class="btn btn-success w-100 mb-2">
                            <i class="fas fa-plus-circle"></i> Add Income
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('expenses.create') }}" class="btn btn-danger w-100 mb-2">
                            <i class="fas fa-minus-circle"></i> Add Expense
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('bank-accounts.create') }}" class="btn btn-primary w-100 mb-2">
                            <i class="fas fa-university"></i> Add Bank Account
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('digital-payments.create') }}" class="btn btn-info w-100 mb-2">
                            <i class="fas fa-mobile-alt"></i> Add Digital Account
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('invoices.create') }}" class="btn btn-warning w-100 mb-2">
                            <i class="fas fa-file-invoice"></i> New Invoice
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('products.create') }}" class="btn btn-secondary w-100 mb-2">
                            <i class="fas fa-cube"></i> Add Product
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Income vs Expense (Last 30 Days)</h5>
            </div>
            <div class="card-body">
                <canvas id="incomeExpenseChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-7">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Recent Transactions</h5>
                <a href="{{ route('transactions.index') }}" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Voucher No</th>
                                <th>Details</th>
                                <th>Type</th>
                                <th>Method</th>
                                <th class="text-end">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentTransactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->date->format('d/m/Y') }}</td>
                                    <td>{{ $transaction->voucher_no }}</td>
                                    <td>{{ Str::limit($transaction->details, 30) }}</td>
                                    <td>
                                        @if($transaction->type == 'income')
                                            <span class="badge bg-success">Income</span>
                                        @elseif($transaction->type == 'expense')
                                            <span class="badge bg-danger">Expense</span>
                                        @else
                                            <span class="badge bg-info">Transfer</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($transaction->payment_method == 'cash')
                                            Cash
                                        @elseif($transaction->payment_method == 'bank')
                                            {{ $transaction->bankAccount?->bank_name ?? 'Bank' }}
                                        @else
                                            {{ $transaction->digitalPayment?->provider ?? 'Digital' }}
                                        @endif
                                    </td>
                                    <td class="text-end {{ $transaction->type == 'income' ? 'text-success' : 'text-danger' }}">
                                        {{ $transaction->type == 'income' ? '+' : '-' }} ৳{{ number_format($transaction->amount, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">No transactions found</p>
                                        <a href="{{ route('transactions.create') }}" class="btn btn-primary btn-sm">
                                            Add your first transaction
                                        </a>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Low Stock Alert</h5>
                <a href="{{ route('products.index') }}" class="btn btn-sm btn-primary">Manage Products</a>
            </div>
            <div class="card-body">
                @if($lowStockProducts->count() > 0)
                    <div class="list-group">
                        @foreach($lowStockProducts as $product)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $product->name }}</strong><br>
                                        <small class="text-muted">Code: {{ $product->product_code }}</small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-warning text-dark">Stock: {{ $product->current_stock }}</span><br>
                                        <small class="text-muted">Min: {{ $product->minimum_stock }}</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-4">
                        <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                        <p class="text-muted">All products have sufficient stock</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('incomeExpenseChart').getContext('2d');

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: {!! json_encode($chartData['labels']) !!},
            datasets: [{
                label: 'Income',
                data: {!! json_encode($chartData['income']) !!},
                borderColor: '#28a745',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                tension: 0.1,
                fill: true
            }, {
                label: 'Expense',
                data: {!! json_encode($chartData['expense']) !!},
                borderColor: '#dc3545',
                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '৳' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush
