@extends('layouts.app')

@section('page-title', 'Admin Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Users</h5>
                        <h2>{{ $totalUsers }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-users"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Transactions</h5>
                        <h2>{{ $totalTransactions }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-list"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Revenue</h5>
                        <h2>{{ number_format($totalRevenue, 2) }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Expenses</h5>
                        <h2>{{ number_format($totalExpenses, 2) }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-minus-circle"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Recent Users</div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @foreach($recentUsers as $u)
                            <li class="list-group-item">{{ $u->name }} &middot; {{ $u->email }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Top Users (by income)</div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @foreach($topUsers as $u)
                            <li class="list-group-item">{{ $u->name }} — {{ number_format($u->total_income, 2) }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
