@extends('layouts.app')

@section('page-title', 'Add Bank Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h4>Add New Bank Account</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('bank-accounts.store') }}" method="POST">
                        @csrf

                        <div class="mb-3">
                            <label for="bank_name" class="form-label">Bank Name *</label>
                            <input type="text" class="form-control" id="bank_name" name="bank_name" required>
                        </div>

                        <div class="mb-3">
                            <label for="account_name" class="form-label">Account Name *</label>
                            <input type="text" class="form-control" id="account_name" name="account_name" required>
                        </div>

                        <div class="mb-3">
                            <label for="account_number" class="form-label">Account Number</label>
                            <input type="text" class="form-control" id="account_number" name="account_number">
                        </div>

                        <div class="mb-3">
                            <label for="branch" class="form-label">Branch</label>
                            <input type="text" class="form-control" id="branch" name="branch">
                        </div>

                        <div class="mb-3">
                            <label for="initial_balance" class="form-label">Initial Balance</label>
                            <input type="number" class="form-control" id="initial_balance" name="initial_balance" step="0.01" min="0" value="0">
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('bank-accounts.index') }}" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Create Account</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
