@extends('layouts.app')

@section('page-title', 'User Details - ' . $user->name)

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="{{ route('admin.users') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="row">
        <!-- User Info Card -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5>User Information</h5>
                </div>
                <div class="card-body">
                    <p><strong>Name:</strong> {{ $user->name }}</p>
                    <p><strong>Email:</strong> {{ $user->email }}</p>
                    <p><strong>Role:</strong> <span class="badge bg-primary">{{ $user->role }}</span></p>
                    <p><strong>Joined:</strong> {{ $user->created_at->format('M d, Y') }}</p>
                    <hr>
                    <p><strong>Total Transactions:</strong> {{ $user->transactions_count }}</p>
                    <p><strong>Total Invoices:</strong> {{ $user->invoices_count }}</p>
                    <p><strong>Total Expenses:</strong> {{ $user->expenses_count }}</p>
                </div>
            </div>
        </div>

        <!-- Financial Summary -->
        <div class="col-md-8">
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h5>Total Income</h5>
                            <h3>{{ number_format($totalIncome, 2) }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card bg-danger text-white">
                        <div class="card-body">
                            <h5>Total Expenses</h5>
                            <h3>{{ number_format($totalExpense, 2) }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="card">
                <div class="card-header">
                    <h5>Recent Transactions</h5>
                </div>
                <div class="card-body">
                    @if($recentTransactions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentTransactions as $transaction)
                                        <tr>
                                            <td>{{ $transaction->date->format('M d, Y') }}</td>
                                            <td>
                                                <span class="badge bg-{{ $transaction->type == 'income' ? 'success' : 'danger' }}">
                                                    {{ ucfirst($transaction->type) }}
                                                </span>
                                            </td>
                                            <td>{{ number_format($transaction->amount, 2) }}</td>
                                            <td>{{ $transaction->description }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-center">No transactions found.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
