@extends('layouts.app')

@section('page-title', 'Admin Reports')

@section('content')
<div class="container-fluid">
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Users</h5>
                        <h2>{{ $totalUsers }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-users"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Revenue</h5>
                        <h2>{{ number_format($totalRevenue, 2) }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Total Expenses</h5>
                        <h2>{{ number_format($totalExpenses, 2) }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-minus-circle"></i></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-card p-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5>Net Profit</h5>
                        <h2>{{ number_format($netProfit, 2) }}</h2>
                    </div>
                    <div class="stat-icon"><i class="fas fa-wallet"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Monthly Data -->
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Monthly Income vs Expenses ({{ now()->year }})</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Month</th>
                                    <th>Income</th>
                                    <th>Expense</th>
                                    <th>Net</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $months = ['', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
                                @endphp
                                @forelse($monthlyData as $data)
                                    <tr>
                                        <td>{{ $months[$data->month] }}</td>
                                        <td class="text-success">{{ number_format($data->income, 2) }}</td>
                                        <td class="text-danger">{{ number_format($data->expense, 2) }}</td>
                                        <td class="{{ $data->income - $data->expense >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($data->income - $data->expense, 2) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">No data available for this year.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Spending Users -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Top Spending Users</h5>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @forelse($topSpendingUsers as $user)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ $user->name }}
                                <span class="badge bg-danger rounded-pill">
                                    {{ number_format($user->total_expense ?? 0, 2) }}
                                </span>
                            </li>
                        @empty
                            <li class="list-group-item text-center">No data available.</li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
