<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Segment;
use App\Models\ExpenseType;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // Create admin user
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'total_balance' => 0,
        ]);

        // Create test user
        User::create([
            'name' => 'Test User',
            'email' => 'user@example.com',
            'password' => Hash::make('password'),
            'role' => 'user',
            'total_balance' => 0,
        ]);

        // Create segments
        $segments = [
            'Sourcing',
            'Stock Maintain',
            'Marketing',
            'Sales',
            'Packaging & Delivery',
            'Accounting & Finance',
            'Technology',
        ];

        foreach ($segments as $segment) {
            Segment::create(['name' => $segment]);
        }

        // Create system expense types
        $expenseTypes = [
            'Cost of Sales' => 'Cost of Sales',
            'Delivery' => 'Delivery',
            'COD' => 'COD',
            'Salary' => 'Salary',
            'Internet' => 'Internet',
            'Transport' => 'Transport',
            'Rent' => 'Rent',
            'Refreshment' => 'Refreshment',
            'Office Stationery' => 'Office Stationery',
            'Writing Fee' => 'Writing Fee',
            'Equipment' => 'Equipment',
        ];

        foreach ($expenseTypes as $name => $category) {
            ExpenseType::create([
                'name' => $name,
                'category' => $category,
                'is_system' => true,
            ]);
        }
    }
}
