<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('total_purchase_price', 15, 2)->default(0)->after('purchase_price');
        });

        // Create triggers to automatically calculate total_purchase_price
        DB::statement("CREATE TRIGGER calculate_total_purchase_price_before_insert\n            BEFORE INSERT ON products\n            FOR EACH ROW\n            BEGIN\n                SET NEW.total_purchase_price = NEW.current_stock * NEW.purchase_price;\n            END");

        DB::statement("CREATE TRIGGER calculate_total_purchase_price_before_update\n            BEFORE UPDATE ON products\n            FOR EACH ROW\n            BEGIN\n                SET NEW.total_purchase_price = NEW.current_stock * NEW.purchase_price;\n            END");
    }

    public function down()
    {
        DB::statement("DROP TRIGGER IF EXISTS calculate_total_purchase_price_before_insert");
        DB::statement("DROP TRIGGER IF EXISTS calculate_total_purchase_price_before_update");

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('total_purchase_price');
        });
    }
};
