<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('payment_method')->nullable()->after('user_id');
            $table->foreignId('bank_account_id')->nullable()->after('payment_method')->constrained()->onDelete('set null');
            $table->foreignId('digital_payment_id')->nullable()->after('bank_account_id')->constrained()->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropForeign(['bank_account_id']);
            $table->dropForeign(['digital_payment_id']);
            $table->dropColumn(['payment_method', 'bank_account_id', 'digital_payment_id']);
        });
    }
};
