<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('sales_dashboard', function (Blueprint $table) {
            $table->id();
            $table->date('date')->nullable();
            $table->string('invoice')->nullable();
            $table->string('product')->nullable();
            $table->integer('qty')->nullable();
            $table->decimal('sales', 12, 2)->nullable();
            $table->string('particulars')->nullable();
            $table->decimal('payment', 12, 2)->nullable();
            $table->decimal('due', 12, 2)->nullable();
            $table->decimal('cogs', 12, 2)->nullable();
            $table->decimal('gross_profit', 12, 2)->nullable();
            $table->decimal('percentage', 5, 2)->nullable();
            $table->string('cash_received_by')->nullable();
            $table->string('segment')->nullable();
            $table->decimal('amount', 12, 2)->nullable();
            $table->decimal('kpi', 12, 2)->nullable();
            $table->decimal('revenue', 12, 2)->nullable();
            $table->decimal('achiv', 5, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('sales_dashboard');
    }
};
