<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // Make existing `sale_price` column nullable and give a default to avoid insert errors
        DB::statement("ALTER TABLE `products` MODIFY `sale_price` DECIMAL(15,2) NULL DEFAULT 0");
    }

    public function down()
    {
        // Revert to NOT NULL without default (original state)
        DB::statement("ALTER TABLE `products` MODIFY `sale_price` DECIMAL(15,2) NOT NULL");
    }
};
