<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('sku')->nullable()->after('product_code');
            $table->text('description')->nullable()->after('name');
            $table->string('unit', 50)->nullable()->after('description');
            $table->decimal('sales_price', 15, 2)->nullable()->after('purchase_price');
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['sku', 'description', 'unit', 'sales_price']);
        });
    }
};
