// database/migrations/2024_01_01_000004_create_expense_types_table.php
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('expense_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('category')->nullable(); // Cost of Sales, Delivery, COD, salary, internet, transport, Rent, Refreshment, office stationery, writing fee, equipment
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade'); // null for system types
            $table->boolean('is_system')->default(false);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('expense_types');
    }
};
