<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesDashboard extends Model
{
    use HasFactory;

    /**
     * Use the singular table name created by the migration.
     */
    protected $table = 'sales_dashboard';

    protected $fillable = [
        'user_id',
        'date',
        'invoice',
        'product',
        'qty',
        'sales',
        'particulars',
        'payment',
        'payment_method',
        'bank_account_id',
        'digital_payment_id',
        'due',
        'cogs',
        'gross_profit',
        'percentage',
        'cash_received_by',
        'segment',
        'amount',
        'kpi',
        'revenue',
        'achiv',
    ];

    protected $casts = [
        'date' => 'date',
        'qty' => 'integer',
        'sales' => 'decimal:2',
        'payment' => 'decimal:2',
        'due' => 'decimal:2',
        'cogs' => 'decimal:2',
        'gross_profit' => 'decimal:2',
        'percentage' => 'decimal:2',
        'amount' => 'decimal:2',
        'kpi' => 'decimal:2',
        'revenue' => 'decimal:2',
        'achiv' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function bankAccount()
    {
        return $this->belongsTo(BankAccount::class);
    }

    public function digitalPayment()
    {
        return $this->belongsTo(DigitalPayment::class);
    }
}
