<?php

namespace App\Http\Controllers;

use App\Models\Segment;
use Illuminate\Http\Request;

class SegmentController extends Controller
{
    public function index()
    {
        $segments = Segment::orderBy('name')->get();
        return view('segments.index', compact('segments'));
    }

    public function create()
    {
        return view('segments.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:segments,name',
            'description' => 'nullable|string',
        ]);

        Segment::create($validated);

        return redirect()->route('segments.index')
            ->with('success', 'Segment created successfully.');
    }

    public function edit(Segment $segment)
    {
        return view('segments.edit', compact('segment'));
    }

    public function update(Request $request, Segment $segment)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:segments,name,' . $segment->id,
            'description' => 'nullable|string',
        ]);

        $segment->update($validated);

        return redirect()->route('segments.index')
            ->with('success', 'Segment updated successfully.');
    }

    public function destroy(Segment $segment)
    {
        if ($segment->expenses()->exists()) {
            return back()->with('error', 'Cannot delete segment with associated expenses.');
        }

        $segment->delete();

        return redirect()->route('segments.index')
            ->with('success', 'Segment deleted successfully.');
    }
}
