<?php

namespace App\Http\Controllers;

use App\Models\Particular;
use Illuminate\Http\Request;

class ParticularController extends Controller
{
    public function index()
    {
        $particulars = Particular::orderBy('id', 'desc')->get();
        return view('particulars.index', compact('particulars'));
    }

    public function create()
    {
        return view('particulars.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'particulars' => 'required|string|max:255',
        ]);

        Particular::create($data);

        return redirect()->route('particulars.index')->with('success', 'Particular created.');
    }

    public function show(Particular $particular)
    {
        return view('particulars.show', compact('particular'));
    }

    public function edit(Particular $particular)
    {
        return view('particulars.edit', compact('particular'));
    }

    public function update(Request $request, Particular $particular)
    {
        $data = $request->validate([
            'particulars' => 'required|string|max:255',
        ]);

        $particular->update($data);

        return redirect()->route('particulars.index')->with('success', 'Particular updated.');
    }

    public function destroy(Particular $particular)
    {
        $particular->delete();
        return redirect()->route('particulars.index')->with('success', 'Particular deleted.');
    }
}
